import pandas as pd
import numpy as np

# Specify the row and column dimensions of the CSV files
num_rows_A = 31594  # Example: Number of rows in CSV file A
num_cols_A = 7849    # Example: Number of columns in CSV file A
num_rows_B = 31594  # Example: Number of rows in CSV file B
num_cols_B = 3897    # Example: Number of columns in CSV file B

# Load the CSV files A_5 (A is across out) and B_5 (B is down out) with no headers
df_A = pd.read_csv('H01_28k_J_Lknoheaders.csv', header=None, nrows=num_rows_A, usecols=range(num_cols_A))
df_B = pd.read_csv('H01_28kG_Inoheaders.csv', header=None, nrows=num_rows_B, usecols=range(num_cols_B))

# Initialize empty DataFrames to store the count and average absolute differences
count_df = pd.DataFrame(columns=df_A.columns, index=df_B.columns)
avg_diff_df = pd.DataFrame(columns=df_A.columns, index=df_B.columns)

# Loop through each combination of columns in A_5 and B_5
for col_A in df_A.columns:
    for col_B in df_B.columns:
        # Check if the columns have the same length and are not empty
        if len(df_A[col_A]) == len(df_B[col_B]) and len(df_A[col_A].dropna()) > 0 and len(df_B[col_B].dropna()) > 0:
            # Check if both columns contain numbers and calculate the absolute differences
            mask = pd.to_numeric(df_A[col_A], errors='coerce').notna() & pd.to_numeric(df_B[col_B], errors='coerce').notna()
            differences = np.abs(pd.to_numeric(df_A[col_A][mask]) - pd.to_numeric(df_B[col_B][mask]))
            
            # Update the count and average absolute differences DataFrames
            count_df.at[col_B, col_A] = mask.sum()
            avg_diff_df.at[col_B, col_A] = differences.mean() if len(differences) > 0 else 0

# Save the count and average absolute differences DataFrames to CSV files
count_df.to_csv('count_validated_H01_28k_GI_down_H01_28k_JLacrossk.csv')
avg_diff_df.to_csv('avg_absolute_diff_H01_28k_GI_down_H01_28k_JLacrossk.csv')

# Print a message to the console
print("Output file saved to the working directory.")

